package org.msh.tb.bd.tbforms.dhis2.tb10;

import org.jboss.seam.annotations.Name;
import org.msh.tb.bd.tbforms.dhis2.DHIS2ExportHome;
import org.msh.tb.application.tasks.AsyncTask;

import java.util.*;

/**
 * @author MSANTOS
 * Controller class for DHIS2 Tb 10 exportation
 */
@Name("dhis2ExportTB10Home")
public class DHIS2ExportTB10Home extends DHIS2ExportHome {

	@Override
	protected AsyncTask getTask() {
		for (AsyncTask task : taskManager.getTasks()) {
			if (task instanceof  DHIS2ExportTB10AsyncTask
					&& task.getUser().getId().equals(getUserWorkspace().getUser().getId())) {
				return task;
			}
		}

		return null;
	}

	@Override
	protected void startTask(Map<String, Object> params){
		taskManager.runTask(DHIS2ExportTB10AsyncTask.class, params);
	}

	@Override
	public String getFormId() {
		return DHIS2ExportTB10AsyncTask.DHIS2_DATA_SET_ID;
	}

	@Override
	public String getReportRole() {
		return "DHIS2_INTEGRATION_TB10";
	}
}
